#include <stdio.h>

#include <windows.h>
#pragma hdrstop
#include <condefs.h>

USERES("MSRdemo.res");
//---------------------------------------------------------------------------
HINSTANCE	preh=0;			      // Handle for MWXUSB.DLL

typedef unsigned char (OPEN_USB)(void);       //
OPEN_USB *lpopenusb;

typedef unsigned char (CLOSE_USB)(void);
CLOSE_USB *lpcloseusb;

typedef unsigned char (CLEAR_USB)(void);
CLEAR_USB *lpclearusb;

typedef unsigned char (READ_MSR_DATA_USB)(char *cpData1,int nLen1, char *cpData2,int nLen2,char *cpData3,int nLen3,DWORD dwTime);
READ_MSR_DATA_USB *lpmsrread;

typedef unsigned char (ACCEPT_LED)(int data);
ACCEPT_LED *lpacceptled;

//---------------------------------------------------------------------------
#pragma argsused
WINAPI WinMain(HINSTANCE hCurInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
   unsigned char uc;
   unsigned char ucChecksum;
   char t1[300];
   char t2[300];
   char t3[300];
   // Clear MSR.TXT file
   FILE *out;
   if ((out = fopen("MSR.TXT", "wt")) == NULL)
       return 31;
   fclose(out);

   if( (preh = LoadLibrary("MWXUSB.DLL")) == NULL )    // Load MWXUSB.Dll
        return 20;   // load MWXUSB.Dll failed
   if( (lpopenusb=(OPEN_USB*)GetProcAddress(preh,"Open_USB" ))==NULL )
        return 21;   // cant get Open USB function
   if( (lpcloseusb=(CLOSE_USB*)GetProcAddress(preh,"Close_USB" ))==NULL )
        return 22;   // cant get Close USB function
   if( (lpclearusb=(CLEAR_USB*)GetProcAddress(preh,"Clear_USB" ))==NULL )
        return 23;   // cant get Clear USB function
   if( (lpmsrread=(READ_MSR_DATA_USB*)GetProcAddress(preh,"read_MSR_data_USB" ))==NULL )
        return 24;   // cant get read USB function
   if( (lpacceptled=(ACCEPT_LED*)GetProcAddress(preh,"Accept_LED" ))==NULL )
        return 25;    // cant get Accept_LED function

   int nl;
   nl = atoi(lpCmdLine);    // get command line paramameter (waiting time in sec)
   if (nl == 0)
        nl = 10;            // if no Parameter use 10 sec as default value
   nl = nl * 1000;           // convert sec to msec

   uc =  (*lpopenusb)();    // Open Keyhook.DLL which opens USB data Channel
   if(uc != 0)
        return 26;          // Open Keyhook.DLL Error

   // Control ACCEPT LED  green
   uc =  (*lpacceptled)(1); // Send EF 43 for green ACCEPT Led
   if(uc != 0)
        return 27;          // control ACCEPT Led Error

   uc = (*lpmsrread)(t1,300,t2,300,t3,300,(DWORD)nl); // Read MSR with timeout

   if (uc > 0)              // if read returns error abort
   {
        // Control ACCEPT LED  red
        uc =  (*lpacceptled)(2); // Send EF 44 for red ACCEPT Led
        if(uc != 0)
                return 28;          // control ACCEPT Led Error
        (*lpcloseusb)();         // Close USB keyhook
        return uc;
   }
   else
   {
        // Control ACCEPT LED  off
        uc =  (*lpacceptled)(0);  // Send EF 42 for off ACCEPT Led
        if(uc != 0)
                return 29;          // control ACCEPT Led Error
       (*lpcloseusb)();         // Close USB keyhook
   }


  // MSR data received
   // Output MSR Data to MSR.TXT file
   if ((out = fopen("MSR.TXT", "wt")) == NULL)
        return 31;

    // Checksum adaption to be compliant to RS232 Version
    uc = 1;
    ucChecksum = 0;
    while (t1[uc])   // calculate track 1 checksum
    {
        ucChecksum = ucChecksum ^ t1[uc++]; // Checksum Track 1 data
    }
    uc--; // point to Checksum
    if(( uc & 0x01) == 1) // if bytes are odd XOR 0x20 to be compliant to RS232 version
        t1[uc] = t1[uc] ^ 0x20;    // adapt track 1 checksum

    uc = 1;
    ucChecksum = 0;
    while (t2[uc])   // calculate track 2 checksum
    {
        ucChecksum = ucChecksum ^ t2[uc++]; // Checksum Track 2 data
    }
    uc--; // point to Checksum
    if(( uc & 0x01) == 1) // if bytes are odd XOR 0x30 to be compliant to RS232 version
        t2[uc] = t2[uc] ^ 0x30;    // adapt track 2 checksum

    uc = 1;
    ucChecksum = 0;
    while (t3[uc])   // calculate track 3 checksum
    {
        ucChecksum = ucChecksum ^ t3[uc++]; // Checksum Track 3 data
    }
    uc--; // point to Checksum
    if(( uc & 0x01) == 1) // if bytes are odd XOR 0x30 to be compliant to RS232 version
        t3[uc] = (t3[uc] ^ 0x30);    // adapt track 3 checksum
    
   // Write data according to HSMSR Preh Spec.

   // Start 02H
   fputc(0x02, out);

   // Write Track 1
   if( t1[1] == 0)
        fputc(0x91, out); // Error Track 1
   else
   {
        fputc(0x90, out); // Track 1
        uc = 1;
        while (t1[uc])
        {
           fputc(t1[uc++], out); // Track 1 data
        }
   }
   // Write Track 2
   if( t2[1] == 0)
        fputc(0xA1, out); // Error Track 2
   else
   {
        fputc(0xA0, out); // Track 2
        uc = 1;
        while (t2[uc])
        {
           fputc(t2[uc++], out); // Track 2 data
        }
   }
   // Write Track 3
   if( t3[1] == 0)
        fputc(0xB1, out); // Error Track 3
   else
   {
        fputc(0xB0, out); // Track 3
        uc = 1;
        while (t3[uc])
        {
           fputc(t3[uc++], out); // Track 3 data
        }
   }
   fputc(0xF0, out); // End of data
   fclose(out);

   return 0;
}
