//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "stdio.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
HINSTANCE	hMWXUSB=0;			      // Handle fr MWXUSB.DLL

typedef unsigned char (SENDDATA_USB)(unsigned char uc);
SENDDATA_USB *lpsendcmd;

typedef unsigned char (CLOSE_USB)(void);
CLOSE_USB *lpcloseusb;

typedef unsigned char (CHECK_USB)(void);
CHECK_USB *lpcheckusb;

typedef unsigned char (OPEN_USB)(void);
OPEN_USB *lpopenusb;

typedef unsigned char (CLEAR_USB)(void);
CLEAR_USB *lpclearusb;

typedef unsigned char (READ_MSR_DATA_USB)(char *cpData1,int nLen1, char *cpData2,int nLen2,char *cpData3,int nLen3,DWORD dwTime);
READ_MSR_DATA_USB *lpmsrread;

typedef unsigned char (READ_TCO_DATA_USB)(char *cpData1,int nLen1,DWORD dwTime);
READ_TCO_DATA_USB *lptcoread;

typedef unsigned char (READ_VERSION_USB)(char *cpData1,int nLen1,int Level);
READ_VERSION_USB *lpversionread;

typedef int (READ_KL_USB)(void);
READ_KL_USB *lpklread;

typedef void (SET_CALLBACK)(void far pascal (*lpfn)(int));
SET_CALLBACK *lpcallback;

typedef unsigned char (ACCEPT_LED)(int data);
ACCEPT_LED *lpacceptled;

typedef unsigned char (SET_FN_LAYER)(int data);
SET_FN_LAYER *lpsetfnlayer;

typedef unsigned char (SOUND_USB)(int nNumber);
SOUND_USB *lpsound;

typedef unsigned char (READ_POS_KEY_USB)(int *cpData1,DWORD dwTime);
READ_POS_KEY_USB *lpposkey;

typedef unsigned char (INSTALL_COM)(void);
INSTALL_COM *lpinstallcom;

#define FIFOSIZE 20
volatile int fifovalue[FIFOSIZE];
volatile int fifoin = 0;
volatile int fifoout=0;
int nAcceptLed = 0;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void far pascal Callback(int value)
{   // Callback Function
   char txt[100];
   if(value == 1)
        sprintf(txt," Callback POS Keyboard down Event %i ", value );
   else if(value == 2)
        sprintf(txt," Callback POS Keyboard up Event %i ", value );
   else if(value == 3)
        sprintf(txt," Callback MSR Event %i ", value );
   else if(value == 4)
        sprintf(txt," Callback Keylock Event %i ", value );
   else if(value == 5)
        sprintf(txt," Callback TCO Event %i ", value );
   else if(value == 8)
        sprintf(txt," Callback Scaner Event %i ", value );
   else if(value == 9)
        sprintf(txt," Callback Restart Keyhook Event %i ", value );
   else
        sprintf(txt," Callback %i ", value );
   fifovalue[fifoin++] =   value;
   if(fifoin >= FIFOSIZE)
        fifoin = 0;
   Form1->StatusBar1->SimpleText=txt;
   return;
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{     //Open
   if(hMWXUSB)
         return;
   StatusBar1->SimpleText= "try to open MWXUSB.DLL";
   if( (hMWXUSB = LoadLibrary("MWXUSB.DLL")) == NULL )
   {
        StatusBar1->SimpleText = "MWXUSB.DLL not found";
        return;
   }
   if( (lpsendcmd=(SENDDATA_USB*)GetProcAddress(hMWXUSB,"snddata_USB" )) == NULL )
   {
        StatusBar1->SimpleText = "Get function snddata_USB failed";
        return;
   }
   if( (lpcheckusb=(CHECK_USB*)GetProcAddress(hMWXUSB,"Check_USB" )) == NULL )
   {
        StatusBar1->SimpleText = "Get function Check_USB failed";
        return;
   }
   if( (lpcloseusb=(CLOSE_USB*)GetProcAddress(hMWXUSB,"Close_USB" ))==NULL )
   {
        StatusBar1->SimpleText = "Get function Close_USB failed";
        return;
   }
   if( (lpclearusb=(CLEAR_USB*)GetProcAddress(hMWXUSB,"Clear_USB" ))==NULL )
   {
        StatusBar1->SimpleText = "Get function Clear_USB failed";
        return;
   }
   if( (lpopenusb=(OPEN_USB*)GetProcAddress(hMWXUSB,"Open_USB" ))==NULL )
   {
        StatusBar1->SimpleText = "Get function Open_USB failed";
        return;
   }
   if( (lpmsrread=(READ_MSR_DATA_USB*)GetProcAddress(hMWXUSB,"read_MSR_data_USB" ))==NULL )
   {
        StatusBar1->SimpleText = "Get function read_MSR_data_USB failed";
        return;
   }
   if( (lptcoread=(READ_TCO_DATA_USB*)GetProcAddress(hMWXUSB,"read_TCO_data_USB" ))==NULL )
   {
        StatusBar1->SimpleText = "Get function read_TCO_data_USB failed";
        return;
   }
   if( (lpversionread=(READ_VERSION_USB*)GetProcAddress(hMWXUSB,"read_Version_USB" ))==NULL )
   {
        StatusBar1->SimpleText = "Get function read_Version_USB failed";
        return;
   }
   if( (lpklread=(READ_KL_USB*)GetProcAddress(hMWXUSB,"read_Keylock" ))==NULL )
   {
        StatusBar1->SimpleText = "Get function read_Keylock failed";
        return;
   }
   if( (lpcallback=(SET_CALLBACK*)GetProcAddress(hMWXUSB,"Set_Callback" ))==NULL )
    {
        StatusBar1->SimpleText = "Get function Set_Callback failed";
        return;
   }
   if( (lpacceptled=(ACCEPT_LED*)GetProcAddress(hMWXUSB,"Accept_LED" ))==NULL )
   {
        StatusBar1->SimpleText = "Get function Accept_LED failed";
        return;
   }
   if( (lpsetfnlayer=(SET_FN_LAYER*)GetProcAddress(hMWXUSB,"Set_FN_Layer" ))==NULL )
    {
        StatusBar1->SimpleText = "Get function Set_FN_Layer failed";
        return;
   }
   if( (lpsound=(SOUND_USB*)GetProcAddress(hMWXUSB,"Sound_USB" ))==NULL )
   {
        StatusBar1->SimpleText = "Get function Sound_USB failed";
        return;
   }
   if( (lpposkey=(READ_POS_KEY_USB*)GetProcAddress(hMWXUSB,"read_POS_key_USB" ))==NULL )
   {
        StatusBar1->SimpleText = "Get function read_POS_key_USB failed";
        return;
   }

   unsigned char ucOpen;
   ucOpen =  (*lpopenusb)();
   if(ucOpen != 0)
   {
         StatusBar1->SimpleText = "Open failed";
        if(hMWXUSB == 0)
                return;
        (*lpcloseusb)();
        if(FreeLibrary( hMWXUSB )==0)
        {
                DWORD dw;
                char txt[80];
                dw = GetLastError();
                sprintf(txt," Close problem %X ",dw);
                StatusBar1->SimpleText = txt;
        }
        else
                StatusBar1->SimpleText = "MWXUSB.DLL closed";
        hMWXUSB=0;
        Button1->Visible = true;     //open
        Button2->Visible = false;     //close
        return;//Keyhook Open failure
   }
   (*lpcallback)( Callback );    // Install Callback Function
   StatusBar1->SimpleText = "Open OK";
   Button1->Visible = false;     //open
   Button2->Visible = true;     //close
   return;

}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button2Click(TObject *Sender)
{
// Close
  StatusBar1->SimpleText = "try to close MWXUSB.DLL";
   if(hMWXUSB == 0)
        return;
   StatusBar1->SimpleText = "MWXUSB.DLL closed";
   (*lpcloseusb)();
   FreeLibrary( hMWXUSB );
   hMWXUSB=0;

   Button1->Visible = true;     //open
   Button2->Visible = false;     //close
 }
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{   //VERSION
    int Number = 0;
    unsigned char ch;
    char v1[300];
    if(hMWXUSB == 0)
       Button1Click(Sender);
    if(hMWXUSB == 0)
        return;
    Button3->Enabled = false;
    ch = (*lpversionread)(v1,300,Number);
    if (ch == 0)
        RichEdit1->Lines->Add(v1);
    else
        RichEdit1->Lines->Add("Error");
    Button3->Enabled = true;
}


//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
   if(hMWXUSB)
         Button2Click(Sender); // Close DLL

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
   int message = 0;
   if(fifoin != fifoout)
   {
       message = fifovalue[fifoout++];
       if(fifoout >= FIFOSIZE)
                fifoout = 0;

       if(message == 3)
       { //MSR
                unsigned char ch;
                char t1[300];
                char t2[300];
                char t3[300];
                char text[250];
                ch = (*lpmsrread)(t1,300,t2,300,t3,300,10);
                if(ch)
                {
                        sprintf(text,"MSR Error - Return value = %i ",ch);
                       // Form1->StatusBar1->SimpleText  = text;
                        RichEdit1->Lines->Add(text);

                }
                else
                {
                        sprintf(text,"MSR Track 1 - %s ",t1);
                        RichEdit1->Lines->Add(text);
                        sprintf(text,"MSR Track 2 - %s ",t2);
                        RichEdit1->Lines->Add(text);
                        sprintf(text,"MSR Track 3 - %s ",t3);
                        RichEdit1->Lines->Add(text);

                }
        }
        if(message == 4)
        {  //Keylock
                int ui;
                ui = (*lpklread)();
                RichEdit1->Lines->Add(  "Position: "+IntToStr(ui));
 
        }

        if((message == 1) || (message == 2) )
        {   // POS Key
                unsigned char ch;
                int ibuf[2];
                ch = (*lpposkey)(ibuf,10);
                if(ch)
                {
                        char text[50];
                        sprintf(text,"Get POSKey Error - Return value = %i ",ch);
                        //Label2->Caption = "No POS Key pressed";
                        Form1->StatusBar1->SimpleText=text;
                        RichEdit1->Lines->Add(text);
                }
                else
                {
                        char txt[50];
                        sprintf(txt," POS Key %i ",ibuf[0]);
                        if (ibuf[1] == 0)
                        {
                                strcat(txt,"pressed");
                        }
                        else
                        {
                                strcat(txt,"released");
                        }
                        RichEdit1->Lines->Add(txt);
                }
                RichEdit1->SetFocus();

                RichEdit1->SelLength = 1;
                RichEdit1->SelStart= RichEdit1->Text.Length() - 2;
 
        }
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button4Click(TObject *Sender)
{
        RichEdit1->Lines->Clear();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button5Click(TObject *Sender)
{     // Set FN Layer
   unsigned char ch;
    if(hMWXUSB == 0)
       Button1Click(Sender);
    if(hMWXUSB == 0)
        return;
   ch = (*lpsetfnlayer)(1);  //Set FN Layer
   if(ch)
   {
        char text[50];
        sprintf(text,"Error - Return value = %i ",ch);
        Form1->StatusBar1->SimpleText  = text;
   }
   ch = (*lpacceptled)(1);  //Accept LED green
   if(ch)
   {
        char text[50];
        sprintf(text,"Error Accept LED - Return value = %i ",ch);
        Form1->StatusBar1->SimpleText  = text;
   }


}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{     // Clear FN Layer
   unsigned char ch;
    if(hMWXUSB == 0)
       Button1Click(Sender);
    if(hMWXUSB == 0)
        return;
   ch = (*lpsetfnlayer)(0);   // Clear FN Layer
   if(ch)
   {
        char text[50];
        sprintf(text,"Error - Return value = %i ",ch);
        Form1->StatusBar1->SimpleText  = text;
   }
   ch = (*lpacceptled)(0);  //Accept LED off
   if(ch)
   {
        char text[50];
        sprintf(text,"Error Accept LED - Return value = %i ",ch);
        Form1->StatusBar1->SimpleText  = text;
   }

}
//---------------------------------------------------------------------------

