﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace MwxDll
{
    public delegate void CallBack(int data);

    public partial class Form1 : Form
    {
        CallBack myCallBack;

        public Form1()
        {
            InitializeComponent();
        }

        private void btnOpen_Click(object sender, EventArgs e)
        {
            Text = "ErrorCode: " + MwxUSBDll.Open_USB().ToString();
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            Text = "ErrorCode: " + MwxUSBDll.Close_USB().ToString();
        }

        private void btnMSR_Click(object sender, EventArgs e)
        {
            StringBuilder sbTrack1 = new StringBuilder(255);
            StringBuilder sbTrack2 = new StringBuilder(255);
            StringBuilder sbTrack3 = new StringBuilder(255);

            byte Errorcode = MwxUSBDll.read_MSR_data_USB(sbTrack1, 255, sbTrack2, 255, sbTrack3, 255, 2000);

            Text = "ErrorCode: " + Errorcode.ToString();

            if (Errorcode == 0)
            {
                txtMSR1.Text = sbTrack1.ToString();
                txtMSR2.Text = sbTrack2.ToString();
                txtMSR3.Text = sbTrack3.ToString();
            }
        }

        private void State(int data)
        {
            string temp = "";

            switch (data)
            {
                case 1: temp = "POS Keyboard down";
                    break;
                case 2: temp = "POS Keyboard up";
                    break;
                case 3: temp = "MSR Event";
                    break;
                case 4: temp = "Keylock Event";
                    break;
                case 5: temp = "Version, TCO Event";
                    break;
                case 8: temp = "Scanner Event";
                    break;
                case 9: temp = "Restart Keyhook Event";
                    break;
            }

            toolStripStatusLabel1.Text = temp;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            myCallBack = new CallBack(State);
            MwxUSBDll.Set_Callback(myCallBack);
        }

        private void btnKeylock_Click(object sender, EventArgs e)
        {
            txtKeylock.Text = MwxUSBDll.read_Keylock().ToString();
        }

        private void btnPOS_Click(object sender, EventArgs e)
        {
            int[] Key ={0,0};

            byte Errorcode = MwxUSBDll.read_POS_key_USB(Key, 5000);

            Text = "ErrorCode: " + Errorcode.ToString();

            if (Errorcode == 0)
            {
                if (Key[1] == 0)
                    lblPOS.Text = "pressed";
                else
                    lblPOS.Text = "released";
                txtPOS.Text = Key[0].ToString();
            }
        }

        private void btnAccRed_Click(object sender, EventArgs e)
        {
            Text = "ErrorCode: " + MwxUSBDll.Accept_LED(2).ToString();
        }

        private void btnAccGreen_Click(object sender, EventArgs e)
        {
            Text = "ErrorCode: " + MwxUSBDll.Accept_LED(1).ToString();
        }

        private void btnAccOff_Click(object sender, EventArgs e)
        {
            Text = "ErrorCode: " + MwxUSBDll.Accept_LED(0).ToString();
        }

        private void btnSoundStop_Click(object sender, EventArgs e)
        {
            Text = "ErrorCode: " + MwxUSBDll.Sound_USB(0x2f).ToString();
        }

        private void btnSound1_Click(object sender, EventArgs e)
        {
            Text = "ErrorCode: " + MwxUSBDll.Sound_USB(0x22).ToString();
        }

        private void btnSound2_Click(object sender, EventArgs e)
        {
            Text = "ErrorCode: " + MwxUSBDll.Sound_USB(0x26).ToString();
        }

        private void btnSound3_Click(object sender, EventArgs e)
        {
            Text = "ErrorCode: " + MwxUSBDll.Sound_USB(0x2A).ToString();
        }

        private void btnSoundInit_Click(object sender, EventArgs e)
        {
            int Freq1 = Convert.ToInt32(txtFreq1.Text);
            int Freq2 = Convert.ToInt32(txtFreq2.Text);
            int Freq3 = Convert.ToInt32(txtFreq3.Text);
            int Vol1 = Convert.ToInt32(txtVol1.Text);
            int Vol2 = Convert.ToInt32(txtVol2.Text);
            int Vol3 = Convert.ToInt32(txtVol3.Text);

            Text = "ErrorCode: " + MwxUSBDll.Init_Sound_USB(Freq1, Freq2, Freq3, Vol1, Vol2, Vol3).ToString();
        }

        private void btnVersion_Click(object sender, EventArgs e)
        {
            StringBuilder sb = new StringBuilder(255);
            int VersionIndex = Convert.ToInt32(txtVersionIndex.Text);

            byte Errorcode = MwxUSBDll.read_Version_USB(sb, 255, VersionIndex);

            Text = "ErrorCode: " + Errorcode.ToString();

            if (Errorcode == 0)
                txtVersion.Text = sb.ToString().Replace("\n", Environment.NewLine);
        }

        private void groupBox3_Enter(object sender, EventArgs e)
        {

        }
    }

    class MwxUSBDll
    {
        [DllImport("MwxUsb.dll")]
        public static extern byte Open_USB();

        [DllImport("MwxUsb.dll")]
        public static extern byte Get_Counter_USB();

        [DllImport("MwxUsb.dll")]
        public static extern byte Check_USB();

        [DllImport("MwxUsb.dll")]
        public static extern byte Close_USB();

        [DllImport("MwxUsb.dll")]
        public static extern byte Clear_USB();

        [DllImport("MwxUsb.dll")]
        public static extern byte snddata_USB(byte ucdata);

        [DllImport("MwxUsb.dll")]
        public static extern byte read_MSR_data_USB(StringBuilder ucpData1, int dwLen1,
                                                    StringBuilder ucpData2, int dwLen2,
                                                    StringBuilder ucpData3, int dwLen3, UInt32 dwTime);

        [DllImport("MwxUsb.dll")]
        public static extern byte read_Version_USB(StringBuilder ucpData, int dwLen, int uLevel);

        [DllImport("MwxUsb.dll")]
        public static extern byte read_TCO_data_USB(StringBuilder ucpData, int dwLen, UInt32 dwTime);

        [DllImport("MwxUsb.dll")]
        public static extern int read_Keylock();

        [DllImport("MwxUsb.dll")]
        public static extern byte Accept_LED(int value);

        [DllImport("MwxUsb.dll")]
        public static extern byte Init_Sound_USB(int uFreq1, int uFreq2, int uFreq3,
                                                 int uVol1, int uVol2, int uVol3);

        [DllImport("MwxUsb.dll")]
        public static extern byte Sound_USB(int uNumber);

        [DllImport("MwxUsb.dll")]
        public static extern byte read_POS_key_USB(int[] cpData, UInt32 dwTime);

        [DllImport("MwxUsb.dll")]
        public static extern void Set_Callback(CallBack Pointer);
    }
}