//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "stdio.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
HINSTANCE	preh=0;			      // Handle fr HEXTODL.DLL

typedef unsigned char (SENDDATA_USB)(unsigned char uc);
SENDDATA_USB *lpsendcmd;

typedef unsigned char (CLOSE_USB)(void);
CLOSE_USB *lpcloseusb;

typedef unsigned char (CHECK_USB)(void);
CHECK_USB *lpcheckusb;

typedef unsigned char (OPEN_USB)(void);
OPEN_USB *lpopenusb;

typedef unsigned char (CLEAR_USB)(void);
CLEAR_USB *lpclearusb;

typedef unsigned char (READDATA_USB)(unsigned char *ucpData,DWORD dwLen,DWORD dwTime);
READDATA_USB *lpread;

typedef unsigned char (READ_MSR_DATA_USB)(char *cpData1,int nLen1, char *cpData2,int nLen2,char *cpData3,int nLen3,DWORD dwTime);
READ_MSR_DATA_USB *lpmsrread;

typedef unsigned char (READ_TCO_DATA_USB)(char *cpData1,int nLen1,DWORD dwTime);
READ_TCO_DATA_USB *lptcoread;

typedef unsigned char (READ_VERSION_USB)(char *cpData1,int nLen1,int Level);
READ_VERSION_USB *lpversionread;

typedef int (READ_KL_USB)(void);
READ_KL_USB *lpklread;

typedef void (SET_CALLBACK)(void far pascal (*lpfn)(int));
SET_CALLBACK *lpcallback;

typedef unsigned char (ACCEPT_LED)(int data);
ACCEPT_LED *lpacceptled;

typedef unsigned char (INIT_SOUND_USB)(int nFreq1,int nFreq2,int nFreq3, int nVol1, int nVol2, int nVol3);
INIT_SOUND_USB *lpinitsound;

typedef unsigned char (SOUND_USB)(int nNumber);
SOUND_USB *lpsound;

typedef unsigned char (READ_POS_KEY_USB)(int *cpData1,DWORD dwTime);
READ_POS_KEY_USB *lpposkey;

int nAcceptLed = 0;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void far pascal Callback(int value)
{   // Callback Function
   char txt[100];
   if(value == 1)
        sprintf(txt," Callback POS Keyboard down Event %i ", value );
   else if(value == 2)
        sprintf(txt," Callback POS Keyboard up Event %i ", value );
   else if(value == 3)
        sprintf(txt," Callback MSR Event %i ", value );
   else if(value == 4)
        sprintf(txt," Callback Keylock Event %i ", value );
   else if(value == 5)
        sprintf(txt," Callback TCO Event %i ", value );
   else if(value == 8)
        sprintf(txt," Callback Scaner Event %i ", value );
   else if(value == 9)
        sprintf(txt," Callback Restart Keyhook Event %i ", value );
   else
        sprintf(txt," Callback %i ", value );
   Form1->StatusBar1->SimpleText=txt;
   return;
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{     //Open
   if(preh)
         return;
   StatusBar1->SimpleText= "try to open MWXUSB.DLL";
   if( (preh = LoadLibrary("MWXUSB.DLL")) == NULL )
   {
        StatusBar1->SimpleText = "MWXUSB.DLL not found";
        return;
   }
   if( (lpsendcmd=(SENDDATA_USB*)GetProcAddress(preh,"snddata_USB" )) == NULL )
        return;
   if( (lpcheckusb=(CHECK_USB*)GetProcAddress(preh,"Check_USB" )) == NULL )
        return;
   if( (lpcloseusb=(CLOSE_USB*)GetProcAddress(preh,"Close_USB" ))==NULL )
      return;
   if( (lpclearusb=(CLEAR_USB*)GetProcAddress(preh,"Clear_USB" ))==NULL )
      return;
   if( (lpopenusb=(OPEN_USB*)GetProcAddress(preh,"Open_USB" ))==NULL )
      return;
   if( (lpread=(READDATA_USB*)GetProcAddress(preh,"readdata_USB" ))==NULL )
      return;
   if( (lpmsrread=(READ_MSR_DATA_USB*)GetProcAddress(preh,"read_MSR_data_USB" ))==NULL )
      return;
   if( (lptcoread=(READ_TCO_DATA_USB*)GetProcAddress(preh,"read_TCO_data_USB" ))==NULL )
      return;
   if( (lpversionread=(READ_VERSION_USB*)GetProcAddress(preh,"read_Version_USB" ))==NULL )
      return;
   if( (lpklread=(READ_KL_USB*)GetProcAddress(preh,"read_Keylock" ))==NULL )
      return;
   if( (lpcallback=(SET_CALLBACK*)GetProcAddress(preh,"Set_Callback" ))==NULL )
      return;
   if( (lpacceptled=(ACCEPT_LED*)GetProcAddress(preh,"Accept_LED" ))==NULL )
      return;
   if( (lpinitsound=(INIT_SOUND_USB*)GetProcAddress(preh,"Init_Sound_USB" ))==NULL )
      return;
   if( (lpsound=(SOUND_USB*)GetProcAddress(preh,"Sound_USB" ))==NULL )
      return;
    if( (lpposkey=(READ_POS_KEY_USB*)GetProcAddress(preh,"read_POS_key_USB" ))==NULL )
      return;

   (*lpcallback)( Callback );    // Install Callback Function
   unsigned char uc;
   uc =  (*lpopenusb)();
   if(uc != 0)
   {
         Button2Click(Sender);
         return;//Keyhook Open failure
   }
   StatusBar1->SimpleText = "Open OK";
   Button1->Visible = false;     //open
   Button2->Visible = true;     //close
   return;

}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button2Click(TObject *Sender)
{
// Close
  StatusBar1->SimpleText = "try to close MWXUSB.DLL";
  if(preh == 0)
        return;
   (*lpcloseusb)();
   FreeLibrary( preh );
   preh=0;
   StatusBar1->SimpleText = "MWXUSB.DLL closed";
   Button1->Visible = true;     //open
   Button2->Visible = false;     //close

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{   //VERSION
    int Number = StrToIntDef(Edit4->Text, 0);
    unsigned char ch;
    char v1[300];
    if(preh == 0)
       Button1Click(Sender);
    if(preh == 0)
        return;
    Button3->Enabled = false;
    ch = (*lpversionread)(v1,300,Number);
    if (ch == 0)
        Label3->Caption = v1;
    else
        Label3->Caption = "Error";
    Button3->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button4Click(TObject *Sender)
{ //MSR
        unsigned char ch;
        char t1[300];
        char t2[300];
        char t3[300];
        char text[50];
         if(preh == 0)
                Button1Click(Sender);
        if(preh == 0)
                return;
        ch = (*lpmsrread)(t1,300,t2,300,t3,300,10);
        Edit1->Text = t1;
        Edit2->Text = t2;
        Edit3->Text = t3;
        if(ch)
        {
                sprintf(text,"Error - Return value = %i ",ch);
                Form1->StatusBar1->SimpleText  = text;
        }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button5Click(TObject *Sender)
{  //Keylock
    int ui;
    Button5->Enabled = false;
    if(preh == 0)
       Button1Click(Sender);
    if(preh == 0)
        return;
    ui = (*lpklread)();
    Label4->Caption = "Position: "+IntToStr(ui);
    Button5->Enabled = true;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{  //ACCEPT
   unsigned char ch;
   nAcceptLed++;
    if(preh == 0)
       Button1Click(Sender);
    if(preh == 0)
        return;
   ch = (*lpacceptled)(nAcceptLed);
   if(ch)
   {
        char text[50];
        sprintf(text,"Error - Return value = %i ",ch);
        Form1->StatusBar1->SimpleText  = text;
   }
   else
   {
      if(nAcceptLed == 0)
         Shape1->Brush->Color =clBtnFace;
      if(nAcceptLed == 1)
         Shape1->Brush->Color = clGreen;
      if(nAcceptLed == 2)
      {
         Shape1->Brush->Color =clRed;
         nAcceptLed = -1;
      }
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
   if(preh)
         Button2Click(Sender); // Close DLL

}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button8Click(TObject *Sender)
{  // Sound Init
   unsigned char ch;
   int Freq1 = StrToIntDef(Edit5->Text, 5000);
   int Freq2 = StrToIntDef(Edit6->Text, 1500);
   int Freq3 = StrToIntDef(Edit7->Text, 300);
   int Vol1 = StrToIntDef(Edit8->Text, 100);
   int Vol2 = StrToIntDef(Edit9->Text, 100);
   int Vol3 = StrToIntDef(Edit10->Text, 100);
    if(preh == 0)
       Button1Click(Sender);
    if(preh == 0)
        return;
   ch = (*lpinitsound)(Freq1,Freq2,Freq3,Vol1,Vol2,Vol3);
   if(ch)
   {
        char text[50];
        sprintf(text,"Error - Return value = %i ",ch);
        Form1->StatusBar1->SimpleText  = text;
   }
    
}
//---------------------------------------------------------------------------



void __fastcall TForm1::Button9Click(TObject *Sender)
{   // Sound 1
   unsigned char ch;
    if(preh == 0)
       Button1Click(Sender);
    if(preh == 0)
        return;
   ch = (*lpsound)(0x22);
   if(ch)
   {
        char text[50];
        sprintf(text,"Error - Return value = %i ",ch);
        Form1->StatusBar1->SimpleText  = text;
   }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button10Click(TObject *Sender)
{    // Sound 2
   unsigned char ch;
    if(preh == 0)
       Button1Click(Sender);
    if(preh == 0)
        return;
   ch = (*lpsound)(0x26);
   if(ch)
   {
        char text[50];
        sprintf(text,"Error - Return value = %i ",ch);
        Form1->StatusBar1->SimpleText  = text;
   }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button11Click(TObject *Sender)
{  // Sound 3
   unsigned char ch;
    if(preh == 0)
       Button1Click(Sender);
    if(preh == 0)
        return;
   ch = (*lpsound)(0x2A);
   if(ch)
   {
        char text[50];
        sprintf(text,"Error - Return value = %i ",ch);
        Form1->StatusBar1->SimpleText = text;
   }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button12Click(TObject *Sender)
{  // Sound off
   unsigned char ch;
    if(preh == 0)
       Button1Click(Sender);
    if(preh == 0)
        return;
   ch = (*lpsound)(0x2F);
   if(ch)
   {
        char text[50];
        sprintf(text,"Error - Return value = %i ",ch);
        Form1->StatusBar1->SimpleText  = text;
   }

}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button7Click(TObject *Sender)
{   // POS Key
    unsigned char ch;
    int ibuf[2];
    if(preh == 0)
       Button1Click(Sender);
    if(preh == 0)
        return;

     ch = (*lpposkey)(ibuf,10);
     if(ch)
     {
        char text[50];
        sprintf(text,"Error - Return value = %i ",ch);
        Label2->Caption = "No POS Key pressed";
        Form1->StatusBar1->SimpleText=text;
     }
     else
     {
        char txt[50];
        sprintf(txt," POS Key %i ",ibuf[0]);
        if (ibuf[1] == 0)
        {
                strcat(txt,"pressed");
        }
        else
        {
                strcat(txt,"released");
        }
        Label2->Caption = txt;
     }


}
//---------------------------------------------------------------------------

