Imports System.Runtime.InteropServices
Imports System.Text

Public Delegate Sub CallBack(ByVal data As Integer)

Public Class Form1

    Dim myCallBack As CallBack

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        myCallBack = New CallBack(AddressOf State)
        MwxUSBDll.Set_Callback(myCallBack)
    End Sub

    Private Sub btnOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOpen.Click
        Text = "Errorcode: " + MwxUSBDll.Open_USB.ToString
    End Sub

    Private Sub btnClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClose.Click
        Text = "Errorcode: " + MwxUSBDll.Close_USB.ToString
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        MwxUSBDll.Close_USB()
    End Sub

    Private Sub btnMSR_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMSR.Click
        Dim sbTrack1 As New StringBuilder(255)
        Dim sbTrack2 As New StringBuilder(255)
        Dim sbTrack3 As New StringBuilder(255)

        Dim Errorcode As Byte = MwxUSBDll.read_MSR_data_USB(sbTrack1, 255, sbTrack2, 255, sbTrack3, 255, 2000)

        Text = "Errorcode: " + Errorcode.ToString

        If (Errorcode = 0) Then
            txtMSR1.Text = sbTrack1.ToString
            txtMSR2.Text = sbTrack2.ToString
            txtMSR3.Text = sbTrack3.ToString
        End If
    End Sub

    Private Sub btnKeylock_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnKeylock.Click
        txtKeylock.Text = MwxUSBDll.read_Keylock
    End Sub

    Private Sub btnPoskey_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPoskey.Click
        Dim Key() As Integer = {0, 0}

        Dim Errorcode As Byte = MwxUSBDll.read_POS_key_USB(Key, 2000)

        Text = "Errorcode: " + Errorcode.ToString

        If (Errorcode = 0) Then
            If (Key(1) = 0) Then
                lblPoskey.Text = "pressed"
            Else
                lblPoskey.Text = "released"
            End If
            txtPoskey.Text = Key(0).ToString
        End If
    End Sub

    Private Sub btnAccRed_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAccRed.Click
        Text = "Errorcode: " + MwxUSBDll.Accept_LED(2).ToString
    End Sub

    Private Sub btnAccGreen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAccGreen.Click
        Text = "Errorcode: " + MwxUSBDll.Accept_LED(1).ToString
    End Sub

    Private Sub btnAccOff_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAccOff.Click
        Text = "Errorcode: " + MwxUSBDll.Accept_LED(0).ToString
    End Sub

    Private Sub btnVersion_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnVersion.Click
        Dim sb As New StringBuilder(255)
        Dim VersionIndex As Integer = Convert.ToInt32(txtVersionIndex.Text)

        Dim Errorcode As Byte = MwxUSBDll.read_Version_USB(sb, 255, VersionIndex)

        Text = "Errorcode: " + Errorcode.ToString

        If (Errorcode = 0) Then
            txtVersion.Text = sb.ToString.Replace(Convert.ToChar(10), Environment.NewLine)
        End If
    End Sub

    Private Sub State(ByVal data As Integer)
        Dim temp As String = ""

        Select Case data
            Case 1 : temp = "POS Keyboard down"
            Case 2 : temp = "POS Keyboard up"
            Case 3 : temp = "MSR Event"
            Case 4 : temp = "Keylock Event"
            Case 5 : temp = "Version, TCO Event"
            Case 8 : temp = "Scanner Event"
            Case 9 : temp = "Restart Keyhook Event"
        End Select
        ToolStripStatusLabel1.Text = temp
    End Sub

    Private Sub btnSoundInit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSoundInit.Click
        Dim Freq1 As Integer = Convert.ToInt32(txtFreq1.Text)
        Dim Freq2 As Integer = Convert.ToInt32(txtFreq2.Text)
        Dim Freq3 As Integer = Convert.ToInt32(txtFreq3.Text)
        Dim Vol1 As Integer = Convert.ToInt32(txtVol1.Text)
        Dim Vol2 As Integer = Convert.ToInt32(txtVol2.Text)
        Dim Vol3 As Integer = Convert.ToInt32(txtVol3.Text)

        Text = "Errorcode: " + MwxUSBDll.Init_Sound_USB(Freq1, Freq2, Freq3, Vol1, Vol2, Vol3).ToString
    End Sub

    Private Sub btnSound1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSound1.Click
        Text = "Errorcode: " + MwxUSBDll.Sound_USB(&H22).ToString
    End Sub

    Private Sub btnSound2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSound2.Click
        Text = "Errorcode: " + MwxUSBDll.Sound_USB(&H26).ToString
    End Sub

    Private Sub btnSound3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSound3.Click
        Text = "Errorcode: " + MwxUSBDll.Sound_USB(&H2A).ToString
    End Sub

    Private Sub btnSoundStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSoundStop.Click
        Text = "Errorcode: " + MwxUSBDll.Sound_USB(&H2F).ToString
    End Sub
End Class
Class MwxUSBDll
    <DllImport("MwxUsb.dll")> _
    Public Shared Function Open_USB() As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function Get_Counter_USB() As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function Check_USB() As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function Close_USB() As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function Clear_USB() As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function snddata_USB(ByVal ucdata As Byte) As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function read_MSR_data_USB(ByVal ucpData1 As StringBuilder, ByVal dwLen1 As Integer, ByVal ucpData2 As StringBuilder, ByVal dwLen2 As Integer, ByVal ucpData3 As StringBuilder, ByVal dwLen3 As Integer, _
     ByVal dwTime As UInt32) As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function read_Version_USB(ByVal ucpData As StringBuilder, ByVal dwLen As Integer, ByVal uLevel As Integer) As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function read_TCO_data_USB(ByVal ucpData As StringBuilder, ByVal dwLen As Integer, ByVal dwTime As UInt32) As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function read_Keylock() As Integer
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function Accept_LED(ByVal value As Integer) As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function Init_Sound_USB(ByVal uFreq1 As Integer, ByVal uFreq2 As Integer, ByVal uFreq3 As Integer, ByVal uVol1 As Integer, ByVal uVol2 As Integer, ByVal uVol3 As Integer) As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function Sound_USB(ByVal uNumber As Integer) As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Function read_POS_key_USB(ByVal cpData As Integer(), ByVal dwTime As UInt32) As Byte
    End Function

    <DllImport("MwxUsb.dll")> _
    Public Shared Sub Set_Callback(ByVal Pointer As CallBack)
    End Sub
End Class