@echo off
if "%1"=="/s" goto step0

@echo.
echo ==================================================================
echo ===  Uninstall FTDI Virtual COM drivers for                    ===
echo ===  PrehKeyTec OCR Module "P1" (VID:0403 PID:F190)            ===
echo ===                                                            ===
echo ===  Operating Systems: Windows 2000,XP,Vista,7 (x32/x64)      ===
echo ===                                                            ===
echo ===  Attention!                                                ===
echo ===  Please run this script with Administrator privileges!     ===
echo ===                                                            ===
echo ===  Option "/s" (silent) for unattended installation          ===
echo ===                                                            ===
echo ===  prehkeytec/sz 2013-April-23                               ===
echo ==================================================================
@echo.
pause


:step0
rem ----- Setting Environment/Options

set RETCODE=0
set DEVNAME_PORT="@FTDIBUS\VID_0403+PID_F190*"
set DEVNAME_BUS="@usb\VID_0403&PID_F190*"


rem --- Workaround to stay in script directory when running via RunAs 
pushd %~dp0


rem --- Determine which Tools to use for 32/64bit Architecture
if "%PROCESSOR_ARCHITECTURE%"=="x86"   set arch=
if "%PROCESSOR_ARCHITECTURE%"=="AMD64" set arch=_amd64
if "%PROCESSOR_ARCHITEW6432%"=="AMD64" set arch=_amd64
rem not supported - if %PROCESSOR_ARCHITECTURE%==IA64  set arch=ia64

echo.
echo Using DPinst%arch%.exe


rem --- Option "/s" (silent) for unattended installation
if "%1"=="/s" (
    set DP_OPTIONS=/s
    ) ELSE (
    set DP_OPTIONS=/p /el
    )
if NOT "%1"=="/s" echo DPInst Options: "%DP_OPTIONS%"


rem --- Delete Registry keys created by OCRWedge Installer
echo.
echo ==============================================================================
echo Remove obsolete information / Registry keys
echo ==============================================================================

rem --- Remove registry entries similar to 32bit OCRWedge Installer - depending on proc.architecture

if "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
	rem  Modify registry entries on 64bit environment
	set HKLM-OCRWedge=HKLM\Software\Wow6432Node\PREH\ServiceInfo\OCRWedge
) ELSE (
	rem  Modify registry entries on 32bit environment
	set HKLM-OCRWedge=HKLM\Software\PREH\ServiceInfo\OCRWedge
)

REG DELETE %HKLM-OCRWedge% /v RTE-DriverVersion  /f > NUL
REG DELETE %HKLM-OCRWedge% /v RTE-PreinstallCode /f > NUL


:step1
rem ----- Uninstall#1: Kill running OCRWedge Application (occupying com port)
echo.
echo ==============================================================================
echo UnInstall-Step#1: Stop OCRWedge Application
echo ==============================================================================
Taskkill.exe /F /IM OCRWedge.exe

echo ReturnCode#1 %ERRORLEVEL%


:step2
rem ----- Uninstall#2: Remove port via devcon (otherwise port is not removed)
echo.
echo ==============================================================================
echo UnInstall-Step#2: Devcon remove FTDI Port %DEVNAME_PORT%...
echo ==============================================================================
.\DriverFiles\devcon%arch%.exe remove %DEVNAME_PORT%

echo ReturnCode#2 %ERRORLEVEL%


:step3
rem ----- Uninstall#3: ftdiport - Default: UNsilent (showing dialogue)
echo.
echo ==============================================================================
echo UnInstall-Step#3: Remove ftdiport drivers
echo ==============================================================================
.\DriverFiles\DPInst%arch%.exe %DP_OPTIONS% /u "%~dp0DriverFiles\ftdiport.inf"

echo ReturnCode#3 %ERRORLEVEL%
set RETCODE=%ERRORLEVEL%

rem In case no drivers were removed:
rem if ERRORLEVEL 2147483648 goto error


:step4
rem ----- Uninstall#4: Remove FTDI Bus device via devcon
echo.
echo ==============================================================================
echo UnInstall-Step#4: Devcon remove FTDI BUS %DEVNAME_BUS%...
echo ==============================================================================
.\DriverFiles\devcon%arch%.exe remove %DEVNAME_BUS%

echo ReturnCode#4 %ERRORLEVEL%


:step5
rem ----- Uninstall#5: ftdibus (always silent)
echo.
echo ==============================================================================
echo UnInstall-Step#5: Remove ftdibus drivers
echo ==============================================================================
.\DriverFiles\DPInst%arch%.exe %DP_OPTIONS% /s /u "%~dp0DriverFiles\ftdibus.inf"

echo ReturnCode#5 %ERRORLEVEL%
if %ERRORLEVEL% GTR %RETCODE% set RETCODE=%ERRORLEVEL%

rem In case no drivers were removed:
rem if ERRORLEVEL 2147483648 goto error


:step6
if "%1"=="/s" goto ende
rem ----- Uninstall#6: Delete all FTDI driver files
echo.
echo ==============================================================================
echo UnInstall-Step#6: Delete ALL FTDI driver files
echo ==============================================================================
call .\DriverFiles\cdmuninstall.cmd /s

echo.
echo ReturnCode#6 %ERRORLEVEL%
goto ende


:ende
echo.
echo ==============================================================================
echo Uninstall Executed - ReturnCode %RETCODE%
echo ==============================================================================
echo.
if NOT "%1"=="/s" pause
exit /B %RETCODE%


:error
echo.
echo ==============================================================================
echo Uninstall ERROR - ReturnCode %RETCODE%
echo ==============================================================================
echo.
if NOT "%1"=="/s" pause
exit /B %RETCODE%
