@echo off
if "%1"=="/s" goto step0

@echo.
echo ==================================================================
echo ===  Install FTDI Virtual COM drivers                          ===
echo ===  PrehKeyTec OCR Module "P1" (VID:0403 PID:F190)            ===
echo ===                                                            ===
echo ===  Operating Systems: Windows 2000,XP,Vista,7 (x32/x64)      ===
echo ===                                                            ===
echo ===  Attention!                                                ===
echo ===  Please run this script with Administrator privileges!     ===
echo ===                                                            ===
echo ===  Option "/s" (silent) for unattended installation          ===
echo ===                                                            ===
echo ===  prehkeytec/sz 2013-April-29                               ===
echo ==================================================================
@echo.
pause


:step0
rem ----- Setting Environment/Options

set RETCODE=0
set FTDINEW="3.4.17.0"


rem --- Workaround to stay in script directory when running via RunAs 
pushd %~dp0


rem --- Determine which Tools to use for 32/64bit Architecture
if "%PROCESSOR_ARCHITECTURE%"=="x86"   set arch=
if "%PROCESSOR_ARCHITECTURE%"=="AMD64" set arch=_amd64
if "%PROCESSOR_ARCHITEW6432%"=="AMD64" set arch=_amd64
rem not supported - if %PROCESSOR_ARCHITECTURE%==IA64  set arch=ia64

echo Installing driver version %FTDINEW%
echo using DPinst%arch%.exe

rem --- Option "/s" (silent) for unattended installation
if "%1"=="/s" (
    set DP_OPTIONS=/s
    ) ELSE (
    set DP_OPTIONS=/p /el
    )

if NOT "%1"=="/s" echo DPInst Options: "%DP_OPTIONS%"


:step1
rem ----- (Pre)Install FTDI Drivers using .\DriverFiles\DPInst.xml
echo.
echo ==============================================================================
echo Install-Step#1: (Pre)Installing Drivers...
echo ==============================================================================
.\DriverFiles\dpinst%arch%.exe %DP_OPTIONS% 

@echo ReturnCode %ERRORLEVEL%
set RETCODE=%ERRORLEVEL%

rem Return code 0x80000000 - Driver could not be installed.
rem Return code 0x000000zz - zz Drivers were installed
rem Return code 0x0000yyzz - yy Drivers were preinstalled
rem Return code 0x00000300 - Invalid result value (max.2, not three devices) = 768

if %RETCODE% GEQ 2147483648 goto error
if %RETCODE% GEQ 1073741824 echo Reboot required!
if %RETCODE% LEQ 255 goto ende


:step2
rem ----- Run devcon rescan, if drivers were just preinstalled (ReturnCode > 255)
echo.
echo ==============================================================================
echo Install-Step#2: Drivers preinstalled. Scanning for new hardware...
echo ==============================================================================
.\DriverFiles\devcon%arch%.exe rescan USB\VID_0403*

@echo ReturnCode %ERRORLEVEL%
rem goto ende


:ende
echo.
echo ==============================================================================
echo Install Executed - ReturnCode %RETCODE%
echo ==============================================================================
echo.

rem --- Add Registry keys similar to 32bit OCRWedge Installer - depending on proc.architecture
if "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
	rem  Modify registry entries on 64bit environment
	set HKLM-OCRWedge=HKLM\Software\Wow6432Node\PREH\ServiceInfo\OCRWedge
) ELSE (
	rem  Modify registry entries on 32bit environment
	set HKLM-OCRWedge=HKLM\Software\PREH\ServiceInfo\OCRWedge
)

REG ADD %HKLM-OCRWedge% /v RTE-DriverVersion /t REG_SZ /d "%FTDINEW%" /f > NUL
REG ADD %HKLM-OCRWedge% /v RTE-PreinstallCode /t REG_SZ /d "%RETCODE%%arch%_InstallDriver.cmd" /f > NUL

if NOT "%1"=="/s" pause
exit /B %RETCODE%


:error
echo.
echo ==============================================================================
echo Install ERROR - ReturnCode %RETCODE%
echo ==============================================================================
echo.
if NOT "%1"=="/s" pause
exit /B %RETCODE%
