@echo off
echo.
echo ==================================================================
echo ===  List installed FTDI Drivers using Devcon                  ===
echo ===                                                            ===
echo ===  prehkeytec/sz 2013-Apr-23                                 ===
echo ==================================================================
echo.

rem --- Workaround to stay in script directory when running via RunAs 
pushd %~dp0


rem --- Determine which Tools to use for 32/64bit Architecture
if "%PROCESSOR_ARCHITECTURE%"=="x86"   set arch=
if "%PROCESSOR_ARCHITECTURE%"=="AMD64" set arch=_amd64
if "%PROCESSOR_ARCHITEW6432%"=="AMD64" set arch=_amd64
rem not supported - if %PROCESSOR_ARCHITECTURE%==IA64  set arch=ia64

echo Using Devcon%arch%.exe


set RETCODE=0
set DEVNAME_BUS="@usb\VID_0403*"
set DEVNAME_PORT="@FTDIBUS\*"

echo.
echo ===============================================================================
echo Find ALL FTDI devices:
echo ===============================================================================
echo FTDI BUS Devices: %DEVNAME_BUS%... 
.\devcon%arch%.exe findall %DEVNAME_BUS%
echo.

echo FTDI's COM Ports: %DEVNAME_PORT%...
.\devcon%arch%.exe findall %DEVNAME_PORT%
echo.


pause
echo.

echo.
echo ===============================================================================
echo Find currently active FTDI devices:
echo ===============================================================================
echo FTDI BUS Devices: %DEVNAME_BUS%... 
.\devcon%arch%.exe find %DEVNAME_BUS%
echo.

echo FTDI's COM Ports: %DEVNAME_PORT%...
.\devcon%arch%.exe find %DEVNAME_PORT%
echo.

pause
echo.
